#!/usr/bin/perl
### SibSoft.net ###
use strict;
$ENV{PERL_LWP_SSL_VERIFY_HOSTNAME}=0;
use lib '.';
use XFSConfig;
use XUpload;
use CGI::Carp qw(fatalsToBrowser);
use CGI;
use Fcntl ':flock';
use LWP::UserAgent;
use HTTP::Cookies;
use HTML::Form;
use HTTP::Request::Common;
use Encode;
use Log;

$|++;

Log->new(filename => 'upload.log');
print STDERR "QUERY_STRING=$ENV{QUERY_STRING}\n";

print("Content-type:text/html\n\nXFS"),exit if $ENV{QUERY_STRING}=~/mode=test/;

my ($utype) = $ENV{QUERY_STRING}=~/utype=([a-z]+)/;
$utype||='anon';
$c->{$_}=$c->{"$_\_$utype"} for qw(enabled max_upload_files max_upload_filesize remote_url leech);

my ($upload_type) = $ENV{QUERY_STRING}=~/upload_type=([a-z]+)/;
my $url_mode=1 if $c->{remote_url} && $upload_type eq 'url';
my $IP = &GetIP;
my $start_time = time;

print STDERR "Starting upload. Size: $ENV{'CONTENT_LENGTH'}";
my ($sid) = ($ENV{QUERY_STRING}=~/upload_id=(\d+)/); # get the random id for temp files
$sid ||= join '', map int rand 10, 1..7;         # if client has no javascript, generate server-side
unless($sid=~/^\d+$/) {# Checking for invalid IDs (hacker proof)
    &xmessage("ERROR: Invalid Upload ID");
}
my $temp_dir = "$c->{temp_dir}/$sid";
my $mode = 0777;
mkdir $temp_dir, $mode;
chmod $mode,$temp_dir;

$CGITempFile::TMPDIRECTORY = $temp_dir;

my @urls;
my ($total_size,$buff_size,$buf,$fname_old,$current_bytes,$speed,$buff_old,$time,$time_spent,$total_old,$fname,$fname2,$base_old,$nosize);
my ($old_size,$old_time);
my $files_uploaded = 0;
my $time_start = $old_time = time;

$c->{ip_not_allowed}=~s/\./\\./g;
if( $c->{ip_not_allowed} && $IP=~/$c->{ip_not_allowed}/ ) {
    &DelData($temp_dir);
    &xmessage("ERROR: $c->{msg}->{ip_not_allowed}");
}
if(!$c->{enabled}) {
    &DelData($temp_dir);
    &xmessage("ERROR: Uploads not enabled for this type of users");
}
if($c->{srv_status} ne 'ON') {
    &DelData($temp_dir);
    &xmessage("ERROR: Server don't allow uploads at the moment");
}
if($c->{max_upload_filesize} && $ENV{CONTENT_LENGTH} > 1048576*$c->{max_upload_filesize}*$c->{max_upload_files}) {
    &DelData($temp_dir);
    &xmessage("ERROR: $c->{msg}->{file_size_big}$c->{max_upload_filesize} Mb");
}

my $cg;
my ($accs,$leech_bytes_left,$leech_bytes_used);

my $ua;
print STDERR "url_mode=$url_mode\n";
if($url_mode) {
    print"Content-type: text/html\n\n";
#    unless($c->{remote_url}) {
#        &DelData($temp_dir);
#        &xmessage("ERROR: You can't use remote URL upload");
#    }
    $cg = CGI->new();
    require HTTP::Request;
    $ua = LWP::UserAgent->new(timeout => 90,
            agent   => 'Mozilla/5.0 (Windows; U; Windows NT 5.1; ru; rv:1.9.1.6) Gecko/20091201 Firefox/3.5.6 (.NET CLR 3.5.30729)',
            cookie_jar => HTTP::Cookies->new( hide_cookie2 => 1, ignore_discard => 1 ) );
    if($cg->param("url_proxy") =~/^([^\"\']+\:\d+)/i) {
        $ua->proxy(['http','ftp'] => "http://$1");
    }
    my @url_list;
    #my $rslee=1 if $cg->param("up1oad_type") eq 'url' && $c->{"\x6d\x5f\x72"};
    #for('m_r','mu','nl','hf') {
    #   #push @{$accs->{"$_\_logins"}}, &shuffle(split(/\|/,$c->{"$_\_logins"}));
    #   push @{$accs->{"$_\_logins"}}, split(/\|/,$c->{"$_\_logins"});
    #}

    my $url_mass = $cg->param("url_mass");
    $url_mass=~s/\r//gs;

    for my $url (split(/\n/,$url_mass)) {
        next unless $url;
        next unless $url=~/:\/\//;
        next unless $url=~/^(https?|ftp):\/\//;
        my $u = {url => $url};
        ($u->{file_name_orig}) = $u->{url}=~/^.*\/([^\/]*)$/;
        $u->{file_name_orig}=~s/\?//g;
        ($u->{auth_login},$u->{auth_password})=($1,$2) if $u->{url}=~s/\/\/(.+?)\:(.+?)\@/\/\//;

        if($u->{url}=~/^ftp/i) {
            require Net::FTP;
            my ($serv,$path,$file)=$u->{url}=~m#^ftp://([^/]+)(.*)/([^/]+)$#i;
            my $ftp = Net::FTP->new($serv)||&Send($!);
            $ftp->login($u->{auth_login},$u->{auth_password})||&Send($ftp->message);
            if($path){$ftp->cwd($path)||&Send($ftp->message);}
            if($ftp->supported("STAT")) {
                $ftp->_STAT($file);
                my @msg=$ftp->message;
                for(@msg){s/^\s+//;$u->{file_size}=(split(/\s+/,$_))[4] if /^[-rwxSsTt]{10}/;}
            }
            unless($u->{file_size}) {
                my @files = $ftp->dir($file);
                $files[0]=~s/^\s+//;
                $u->{file_size} = (split(/\s+/,$1))[4] if $files[0]=~/^([-rwxSsTt]{10}.*)$/;
            }

            $u->{url}=~s/ftp:\/\///i;
            $u->{url} = $u->{auth_login} ? "ftp://$u->{auth_login}:$u->{auth_password}\@$u->{url}" : "ftp://$u->{url}";
            $u->{auth_login}=$u->{auth_password}='';
    #$u->{file_size}=$ftp->size($file);
        }
        if($c->{max_upload_filesize} && $u->{file_size} > $c->{max_upload_filesize}*1048576) {
            $u->{file_error}="$c->{msg}->{file_size_big}";
            push @urls, $u;
            next;
        }
        if(scalar(@urls)>=$c->{max_upload_files}) {
            $u->{file_error}="$u->{file_name_orig} $c->{msg}->{too_many_files}";
            push @urls, $u;
            next;
        }
        $total_size+=$u->{file_size};
        $u->{file_tmp} = "$temp_dir/".join('', map int rand(10), 1..10);
        push(@urls, $u);
    }    

    my $str=qq[new Object({"state":"uploading", "size":"$total_size", "received":"0","files_done":"0"})];
    open(F,">$c->{htdocs_tmp_dir}/$sid.html");
    print F $str;
    close F;
    my $mode = 0777;
    chmod $mode,"$c->{htdocs_tmp_dir}/$sid.html";

    for(qw(rs mu nl hf mf fs df ff es sm ug fe wu bs)) {
        $c->{"my_$_\_logins"}=$cg->param("$_\_logins");
    }

    # If there're any leeches in queue - check traffic left
    #my @ll = grep {$_->{rslee}==1} @urls;

    for my $u (@urls) {
        down:
        if($u->{file_error}){ $files_uploaded++; next; }

            if($c->{leech}) {
                $u->{domain} = lc($1) if $u->{url} =~ /^https?:\/\/([^\/]+)/;
                $u->{domain} =~ s/^www\.//;

                my $handler = {
                    '2shared.com' => 'pre2shared',
                    '4shared.com' => 'pre4shared',
                    'depositfiles.com' => 'preDepositfiles',
                    'uploading.com' => 'preUploading',
                    'fileserve.com' => 'preFileserve',
                    'filefactory.com' => 'preFilefactory',
                    'bitshare.com' => 'preBitshare',
                    'myvdrive.com' => 'preMyvdrive',
                    'asfile.com' => 'preAsfile',
                    'sendspace.com' => 'preSendspace',
                    'uploaded.net' => 'preUploaded',
                    'ul.to' => 'preUploaded',
                    'rapidgator.net' => 'preRapidgator',
                    'rg.to' => 'preRapidgator',
                }->{$u->{domain}} || 'preBasicAuth';

                print STDERR "Using handler: $handler\n";
                my $cb = \&{ $handler };
                &$cb($u);
                print STDERR "Resulting URL: $u->{url}\n";
            }
     

        if($u->{file_error}){ $files_uploaded++; next; }      

        if($u->{rslee} && $cg->param('sess_id') && !defined($leech_bytes_left)) {
            my $ua2 = LWP::UserAgent->new(agent => "XFS-FSAgent", timeout => 90);
            my $res = $ua2->post("$c->{site_cgi}/fs.cgi", {
                    op           => 'leech_mb_left',
                    fs_key       => $c->{fs_key},
                    sess_id      => $cg->param('sess_id')||'',
                    file_ip      => $ENV{REMOTE_ADDR},
                })->content;
            ($leech_bytes_left) = $res=~/^OK:(\d+)$/;
            #&Send"x=$leech_bytes_left";
            #$leech_bytes_used
        }
        if($u->{rslee} && $leech_bytes_left < ($leech_bytes_used+$u->{file_size})) {
            $u->{file_error}="Not enough leech traffic";
            $files_uploaded++;
            next;
        }

        $nosize = $u->{file_size} ? 0 : 1;
        $base_old='';
        open FILE, ">$u->{file_tmp}" || &Send("Can't open dest file:$!");
        my $req = HTTP::Request->new(GET => $u->{url});
        $req->authorization_basic($u->{auth_login},$u->{auth_password}) if $u->{auth_login} && $u->{auth_password};

        my $resp = $ua->request($req, \&hook_url );
        close FILE;
    
        my $content_disp = $resp->header('Content-Disposition');
        $u->{file_name_orig} = $1 if $content_disp =~ /filename="(.+)"/
                    || $content_disp =~ /filename=(.+)/
                    || $content_disp =~ /filename\*=.*?''(.+)/;
        $u->{file_size}=-s $u->{file_tmp};
        $u->{file_name_orig}||=$fname2;
        $u->{file_name_orig}=~s/.+\/(.+)$/$1/;
        $u->{file_name_orig}=~s/\.html?$//i;
        $u->{file_name_orig}=~s/\?.*$//;
        $u->{file_name_orig}=~s/\?+//g;
        $u->{file_name_orig}=~s/\/$//g;
        $u->{file_name_orig}||=join('', map int rand(10), 1..5);

        if($u->{rslee} && $ua->{auth_login} && $resp->content_type eq 'text/html') {
            $u->{auth_login}=$u->{auth_password}=$ua->{auth_login}=$ua->{auth_password}='';
            goto down;
        }

        $u->{file_error}="Received HTML page instead of file".$resp->content if $resp->content_type eq 'text/html' && $u->{url}!~/\.html$/i;
        $u->{file_error}="File download failed:".$resp->status_line unless $resp->is_success;

        if($u->{rslee} && !$u->{file_error}) {
            $leech_bytes_used+=$u->{file_size};
        }

        $files_uploaded++;
    }
} else {
    $total_size = $ENV{CONTENT_LENGTH};
    my $str=qq[new Object({"state":"uploading", "size":"$total_size", "received":"0","files_done":"0"})];
    open(F,">$c->{htdocs_tmp_dir}/$sid.html");
    print F $str;
    close F;
    my $mode = 0777; chmod $mode,"$c->{htdocs_tmp_dir}/$sid.html";
    $cg = CGI->new(\&hook);
}

#########################
sub hook_url {
    my ($buffer,$res) = @_;
    print FILE $buffer;
    $current_bytes+=length($buffer);

    if(time>$old_time) {
        $total_size += $res->content_length if $nosize && $base_old ne $res->base;
        $base_old = $res->base;
        $fname2 = $res->base;
        $old_time = time;
        my $str=qq[new Object({"state":"uploading", "size":"$total_size", "received":"$current_bytes","files_done":"$files_uploaded"})];
        open(F,">$c->{htdocs_tmp_dir}/$sid.html");
        print F $str;
        close F;
        print"<!--x-->\n" if $url_mode && $time%5==0;
    }
}
#########################
sub hook {
    ($fname, $buf, undef) = @_;

    $current_bytes+=length($buf);

    if($fname_old ne $fname) {
        $files_uploaded++ if $fname_old;
        $fname_old=$fname;
    }

    if(time>$old_time) {
        $old_time = time;
        my $str=qq[new Object({"state":"uploading", "size":"$total_size", "received":"$current_bytes","files_done":"$files_uploaded"})];
        open(F,">$c->{htdocs_tmp_dir}/$sid.html");
        print F $str;
        close F;
    }
}

$files_uploaded++;
my $str=qq[new Object({"state":"done", "size":"$total_size", "received":"$total_size","files_done":"$files_uploaded"})];
open(F,">$c->{htdocs_tmp_dir}/$sid.html");
print F $str;
close F;

#########################

my $f;
$f->{$_}=$cg->param($_) for $cg->param();
$f->{ip} = &GetIP();
$f->{torr_on}=1 if $f->{up1oad_type} eq 'tt';

my (@file_inputs,@files);
if($url_mode) {
    @file_inputs = @urls;
} else {
    for my $input( $cg->param() ) {
        my @params = $cg->param($input);
        next unless my @file_names=$cg->upload($input);
        # HTML5 multi-upload support
        my $i = 0;
        foreach(@file_names) {
            my $u;
            ($u->{file_name_orig})=$cg->uploadInfo($_)->{'Content-Disposition'}=~/filename="(.+?)"/i;
            $u->{file_name_orig}=~s/^.*\\([^\\]*)$/$1/;
            $u->{file_size}   = -s $_;
            $u->{file_descr}  = ($cg->param("$input\_descr"))[$i];
            $u->{file_public} = ($cg->param("$input\_public"))[$i];
            $u->{file_adult}  = ($cg->param("$input\_adult"))[$i];
            $u->{file_tmp}    = $cg->tmpFileName($_);
            push @file_inputs, $u;
            $i++;
        }
    }
}

for my $file ( @file_inputs ) {
    $file->{file_status}="null filesize or wrong file path"
        if $file->{file_size}==0;

    $file->{file_status}="filesize too big"
        if $c->{max_upload_filesize} && $file->{file_size}>$c->{max_upload_filesize}*1048576;

    $file->{file_status}="too many files"
        if $#files>=$c->{max_upload_files}-1;

    $file->{file_status}=$file->{file_error}
        if $file->{file_error};

# --------------------
    $file = &XUpload::ProcessFile($file,$f) unless $file->{file_status};
# --------------------

    $file->{file_status}||='OK';
    push @files, $file;
}


#sleep 1; ### Pause to sync messages with progress
&DelData($temp_dir);
unlink("$c->{htdocs_tmp_dir}/$sid.html");
&DeleteExpiredFiles( $c->{temp_dir}, 86400 );
&DeleteExpiredFiles( $c->{htdocs_tmp_dir}, 300, 'access');

# Generate parameters array for POST
my @har;
my $style=1;
for my $ff (@files) {
    $style^=1;
    $ff->{file_descr}=~s/>/&gt;/g;
    $ff->{file_descr}=~s/</&lt;/g;
    $ff->{file_descr}=~s/\"/&quote;/g;
    $ff->{file_descr}=substr($ff->{file_descr},0,128);
    push @har, { name=>"fn", 'value'=>$ff->{file_code}||$ff->{file_name_orig} };
    push @har, { name=>"st", 'value'=>$ff->{file_status} };
}

### Sending data to MAIN
my $url_post = "$c->{site_url}/";
push @har, { name=>'op', value=>'upload_result' };
for(qw(link_rcpt xbg xtxt))
{
   push @har, { name=>$_, value=>$cg->param($_) } if $cg->param($_);
}

my $box="box" if $ENV{QUERY_STRING}=~/box=1/;
if($ENV{QUERY_STRING}!~/js_on=1/) {
    $url_post.=$box if $box;
    $url_post.='?';
    $url_post.="\&$_->{name}=$_->{value}" for @har;
    print $cg->redirect( $url_post );
    exit;
}
print"Content-type: text/html\n\n" unless $url_mode;
print"<HTML><BODY><div style='display:none;'><Form name='F1' action='$c->{site_url}/$box' target='_parent' method='POST'>";
print"<textarea name='$_->{name}'>$_->{value}</textarea>" for @har;
print"</Form><Script>document.location='javascript:false';document.F1.submit();</Script></div></BODY></HTML>";
exit;

#############################################

sub DeleteExpiredFiles {
    my ($dir,$lifetime,$access) = @_;
    return unless $lifetime;
    opendir(DIR, $dir) || &xmessage("Fatal Error: Can\'t opendir temporary folder ($dir)($!)");
    foreach my $fn (readdir(DIR)) {
        next if $fn =~ /^\./;
        next if $fn eq 'status.html';
        my $file = $dir.'/'.$fn;
        my $ftime = $access ? (lstat($file))[8] : (lstat($file))[9];
        next if (time - $ftime) < $lifetime;
        -d $file ? &DelData($file) : unlink($file);
    }
    closedir(DIR);
}

sub DelData {
    my ($dir) = @_;
    $cg->DESTROY if $cg; # WIN: unlock all files
    return unless -d $dir;
    opendir(DIR, $dir) || return;
    unlink("$dir/$_") for readdir(DIR);
    closedir(DIR);
    rmdir("$dir");
}

sub xmessage {
    my ($msg) = @_;
    &lmsg($msg);
    $msg=~s/'/\\'/g;
    $msg=~s/<br>/\\n/g;
    print"Content-type: text/html\n\n";
    print"<HTML><HEAD><Script>alert('$msg');</Script></HEAD><BODY><b>$msg</b></BODY></HTML>";
    exit;
}

sub lmsg {
    my $msg = shift;
    open(F,">$c->{htdocs_tmp_dir}/$sid.html");
    print F qq[new Object({"state":"error", "msg":"$msg"})];
    close F;
    print STDERR $msg;
}

sub GetIP {
    return $ENV{REMOTE_ADDR};
}

sub getLogins {
    my ($prefix) = @_;
    my @pool = split (/\|/, $c->{"my_$prefix\_logins"}||$c->{"$prefix\_logins"});
    my ($login, $pass) = split (/:/, $pool[rand(@pool)], 2);
    #print STDERR "Using login for $prefix: $login:$pass\n";
    return ($login, $pass);
}

sub preBasicAuth {
    my ($u) = @_;

    my $prefix = 'rs' if $u->{domain} eq 'rapidshare.com';
    $prefix = 'nl' if $u->{domain} eq 'netload.in';
    $prefix = 'ff' if $u->{domain} eq 'filefactory.com';

    ($u->{auth_login}, $u->{auth_password}) = &getLogins($prefix) if $prefix;

    return $u;
}

sub preMediafire {
    my ($u,$ua,$accs) = @_;
    my ($login, $pass) = &getLogins("mf");

    my $res = $ua->get('http://www.mediafire.com/');
    my @forms = HTML::Form->parse($res);
    my $form = $forms[0];
    $form->value('login_email' => $u->{auth_login});
    $form->value('login_pass'  => $u->{auth_password});
    $res = $ua->request($form->click);

    return $u;
}

sub pre4shared {
    my ($u) = @_;
    my ($login, $pass) = &getLogins("fs");

    my $res = $ua->get('http://www.4shared.com');
    my @forms = HTML::Form->parse($res);
    my $form = $forms[2];
    $form->value('login' => $u->{auth_login});
    $form->value('password' => $u->{auth_password});
    $form->value('remember' => 'true');
    $res = $ua->request($form->click);

    if($res->content=~/Invalid e-mail address or password/i) {
            ($u->{auth_login},$u->{auth_password}) = shift(@{$u->{accs}})=~/^(.+):(.+)$/;
            next if $u->{auth_login} && $u->{auth_password};
            $u->{file_error}="Can not leech 4shared file";
            return $u;
    }

    return $u;
}

sub pre2shared {
    my ($u,$ua) = @_;

    my $res = $ua->get($u->{url})->decoded_content;
    if($res =~ /The file link that you requested is not valid/gis) {
        $u->{file_error} = '2shared.com: Invalid file link';
        return $u;
    }
    $res =~ /<div class="header">Download\s+(.*?)<\/div>/gis;
    $u->{file_name_orig} = $1;
    $u->{file_name_orig} =~ s/^\s+(.*)\s+$/$1/sim;
    ($u->{url}) = $res =~ /window.location =\'([^\']*)/is;
    return $u;
}

sub preDepositfiles {
    my ($u) = @_;
    my ($login, $pass) = &getLogins("df");

    my $res = $ua->get('http://depositfiles.com/');
    my $base = $res->base;
    $base =~ s/\/$//;

    $ua->post("$base/api/user/login", {
        login => $login,
        password => $pass,
    });

    $res = $ua->get($u->{url});
    if($res->content =~ /id\=\"download_url.*?href=\"([^\"]*?)\"/s) {
            $u->{url} = $1;
    } else {
        $u->{file_error}="Can not leech depositfiles file";
    }
    $u->{auth_login}=$u->{auth_password}='';
    $u->{file_name_orig}='';
    return $u;
}    

sub preUploading {
    my ($u) = @_;
    my ($login, $pass) = &getLogins("ug");

    $ua->default_header('Referer' => 'http://uploading.com/');
    my $res = $ua->post('http://uploading.com/general/login_form/?JsHttpRequest='.int(rand(99999999999)+3264).'-xml', {email=>$u->{auth_login},password=>$u->{auth_password},remember=>'on'});
    sleep(2);
    $res = $ua->get('http://uploading.com/');

    if($res->content =~ /name="password"/i) {
#if($u->{rslee}) {
        ($u->{auth_login},$u->{auth_password}) = shift(@{$u->{accs}})=~/^(.+):(.+)$/;
        next if $u->{auth_login} && $u->{auth_password};
#}
        $u->{file_error}="Can not leech uploading.com file";
        return $u;
    }
    return $u;
}

sub preFileserve {
    my ($u) = @_;
    my ($login, $pass) = &getLogins("fe");

    my $res = $ua->get('http://www.fileserve.com');
    my @forms = HTML::Form->parse($res);
    my $form = $forms[1];
    $form->value(loginUserName => $u->{auth_login});
    $form->value(loginUserPassword => $u->{auth_password});
    $form->value(ppp => undef);
    my $req = $form->click;
    $req->header('Referer', 'http://www.fileserve.com/');
    $res = $ua->request($req);
    $res = $ua->get('http://www.fileserve.com');
    unless($res->content =~ /\/dashboard\.php/) {
#if($u->{rslee}) {
        ($u->{auth_login},$u->{auth_password}) = shift(@{$u->{accs}})=~/^(.+):(.+)$/;
        next if $u->{auth_login} && $u->{auth_password};
#}
        $u->{file_error}="Can not leech fileserve file";
        return $u;
    }
    $u->{auth_login}=$u->{auth_password}='';
    $u->{file_name_orig}='';

    return $u;
}

sub preBitshare {
    my ($u) = @_;
    my ($login, $pass) = &getLogins("bs");

    my $res = $ua->get('http://bitshare.com');
    my @forms = HTML::Form->parse($res);
    my $form = $forms[0];
    $form->value(user => $login);
    $form->value(password => $pass);
    my $req = $form->click;
    $res = $ua->request($req);
}

sub preSendspace {
    my ($u) = @_;

    my $res = $ua->get($u->{url});
    $u->{url} = $1 if $res->decoded_content =~ /id="download_button" href=\"([^\"]+)/;
}

sub preMyvdrive {
    my ($u) = @_;

    my ($login, $pass) = &getLogins("ss");
    my $res = $ua->get('http://www.myvdrive.com/Public/login');
    my @forms = HTML::Form->parse($res);
    my $form = $forms[0];
    $form->value(username => $login);
    $form->value(password => $pass);
    my $req = $form->click;
    $req->header(Referer => 'http://www.myvdrive.com/Public/login');
    $res = $ua->request($req);
    $res = $ua->get('https://account.yesup.com'.$res->header('Location'));
}

sub preAsfile {
    my ($u) = @_;
    my ($login, $pass) = &getLogins("as");

    my $res = $ua->get('http://asfile.com/en/login');
    $res = $ua->post("http://asfile.com/en/login", [login=>$login, password=>$pass]);

    $u->{url} =~ s~file/~en/premium-download/file/~ if $u->{url} !~ /premium-download/;
    my $content = $ua->get($u->{url})->decoded_content;
    $u->{url} = $1 if $content =~ /\<a id=\"download_button\" href="([^"]+)\"\>/s;
}

sub preUploaded {
    my ($u) = @_;
    my ($login, $pass) = &getLogins("ul");

    my $res = $ua->post('http://uploaded.net/io/login',
        { id => $login,
          pw => $pass,
        });
}

sub preFilefactory {
    my ($u) = @_;
    my ($login, $pass) = &getLogins("ff");

    my $req = HTTP::Request::Common::POST("http://www.filefactory.com/member/signin.php",
       [
	   loginEmail=>$login,
	   loginPassword=>$pass,
	   Submit=>'Sign In'
       ]);
    $req->header(Referer => 'http://filefactory.com/');
    my $res = $ua->request($req);

    return $u;
}

sub preRapidgator {
    my ($u) = @_;
    my ($login, $pass) = &getLogins("ra");
	my $req = POST "https://rapidgator.net/auth/login",
	        Referer => "http://rapidgator.net",
	       	Content => ['LoginForm[email]'=>$login, 'LoginForm[password]'=>$pass];
    my $res = $ua->request($req);

    return $u;
}
